/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.logger.impl.Formatter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.ResourceBundle;

public abstract class DelegateLogger
implements SystemLoggerPlus {
    public static DelegateLogger create(final System.Logger delegate) {
        return new DelegateLogger(){

            @Override
            protected System.Logger getDelegate() {
                return delegate;
            }
        };
    }

    protected abstract System.Logger getDelegate();

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return this.getDelegate().isLoggable(level);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle resourceBundle, String s, Throwable throwable) {
        this.getDelegate().log(level, resourceBundle, s, throwable);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle resourceBundle, String s, Object ... objects) {
        this.getDelegate().log(level, resourceBundle, s, objects);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle resourceBundle, String format, Throwable t, Object ... params) {
        System.Logger logger = this.getDelegate();
        Objects.requireNonNull(logger);
        System.Logger logger2 = logger;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SystemLoggerPlus.class, System.Logger.class}, (Object)logger2, n)) {
            case 0: {
                SystemLoggerPlus slp = (SystemLoggerPlus)logger2;
                slp.log(level, format, t, params);
                break;
            }
            default: {
                System.Logger sl = logger2;
                sl.log(level, Formatter.format(resourceBundle, format, params), t);
            }
        }
    }
}

